# Trajectory Analysis Summary

**📊 Full Dataset:** See `trajectory_metrics.csv` for granular per-run metrics (pivot table ready)

---

## 📊 Complete Metrics Table

| Category | N | Curv | Eff | Geod | Dim | Init | Final | Slope | Corr | Smooth |
|----------|---|------|-----|------|-----|------|-------|-------|------|--------|
| ambiguous | 792 | 1.952 | 0.581 | 0.581 | 1.5 | 0.783 | 0.933 | 0.0195 | -0.924 | 114.78 |
| creative | 880 | 1.979 | 0.572 | 0.572 | 1.5 | 0.792 | 0.935 | 0.0190 | -0.900 | 115.53 |
| ethical | 1320 | 1.968 | 0.581 | 0.581 | 1.5 | 0.787 | 0.934 | 0.0190 | -0.907 | 67.00 |
| financial | 1320 | 1.890 | 0.603 | 0.603 | 1.5 | 0.759 | 0.934 | 0.0224 | -0.645 | 191.04 |
| interdisciplinary | 880 | 1.895 | 0.593 | 0.593 | 1.5 | 0.754 | 0.933 | 0.0227 | -0.889 | 4141.39 |
| medical-health | 1320 | 1.845 | 0.621 | 0.621 | 1.5 | 0.768 | 0.933 | 0.0211 | -0.882 | 119.54 |
| meta-cognitive | 880 | 2.122 | 0.552 | 0.552 | 1.5 | 0.806 | 0.935 | 0.0163 | -0.900 | 629.46 |
| meta-philosophical | 1320 | 1.989 | 0.573 | 0.573 | 1.5 | 0.781 | 0.932 | 0.0192 | -0.881 | 5443.09 |
| philosophical | 880 | 2.066 | 0.557 | 0.557 | 1.5 | 0.783 | 0.934 | 0.0190 | -0.794 | 87.30 |
| scientific | 1320 | 1.945 | 0.610 | 0.610 | 1.5 | 0.735 | 0.934 | 0.0253 | -0.239 | 92.71 |
| songwriting | 880 | 1.932 | 0.584 | 0.584 | 1.5 | 0.792 | 0.934 | 0.0191 | -0.913 | 240.41 |
| technical | 1320 | 1.868 | 0.608 | 0.608 | 1.5 | 0.750 | 0.934 | 0.0237 | -0.877 | 173.57 |

**Column Legend:**
- **N:** Number of runs in category
- **Curv:** Curvature (PathLength / NetDisplacement)
- **Eff:** Efficiency (GeodesicRatio = NetDisplacement / PathLength)
- **Geod:** Geodesic Ratio (same as Efficiency)
- **Dim:** Local Dimensionality estimate
- **Init:** Initial Coherence (cosine similarity loop 0→1)
- **Final:** Final Coherence (cosine similarity last two loops)
- **Slope:** Coherence slope (linear trend over all loops)
- **Corr:** Curvature-Efficiency correlation
- **Smooth:** Smoothness (inverse of turning-angle variance)

---

## 📈 Trajectory Coherence Evolution

| Category | Initial | Final | Change | Trend |
|----------|---------|-------|--------|-------------|
| ambiguous | 0.783 | 0.933 | +0.150 | STABILIZING |
| creative | 0.792 | 0.935 | +0.142 | STABILIZING |
| ethical | 0.787 | 0.934 | +0.147 | STABILIZING |
| financial | 0.759 | 0.934 | +0.175 | STABILIZING |
| interdisciplinary | 0.754 | 0.933 | +0.178 | STABILIZING |
| medical-health | 0.768 | 0.933 | +0.165 | STABILIZING |
| meta-cognitive | 0.806 | 0.935 | +0.128 | STABILIZING |
| meta-philosophical | 0.781 | 0.932 | +0.151 | STABILIZING |
| philosophical | 0.783 | 0.934 | +0.151 | STABILIZING |
| scientific | 0.735 | 0.934 | +0.199 | STABILIZING |
| songwriting | 0.792 | 0.934 | +0.142 | STABILIZING |
| technical | 0.750 | 0.934 | +0.184 | STABILIZING |

**Trend Classification:**
- **STABILIZING:** Slope > +0.005 (coherence increasing)
- **STABLE:** Slope between -0.005 and +0.005
- **DESTABILIZING:** Slope < -0.005 (coherence decreasing)

---

## 🔗 Curvature-Efficiency Relationships

| Category | Correlation | Strength | Interpretation |
|----------|-------------|----------|---------------------------|
| ambiguous | -0.924 | STRONG | Tightly coupled |
| creative | -0.900 | STRONG | Tightly coupled |
| ethical | -0.907 | STRONG | Tightly coupled |
| financial | -0.645 | MODERATE+ | Controlled complexity |
| interdisciplinary | -0.889 | STRONG | Tightly coupled |
| medical-health | -0.882 | STRONG | Tightly coupled |
| meta-cognitive | -0.900 | STRONG | Tightly coupled |
| meta-philosophical | -0.881 | STRONG | Tightly coupled |
| philosophical | -0.794 | STRONG | Tightly coupled |
| scientific | -0.239 | WEAK | Independent systems |
| songwriting | -0.913 | STRONG | Tightly coupled |
| technical | -0.877 | STRONG | Tightly coupled |

**Correlation Strength:**
- **STRONG:** |r| > 0.7
- **MODERATE+:** 0.5 < |r| ≤ 0.7
- **MODERATE:** 0.3 < |r| ≤ 0.5
- **WEAK:** |r| ≤ 0.3

---

## 🎯 Geometric Complexity Analysis

| Category | Curvature | StdDev | Efficiency | StdDev | Complexity |
|----------|-----------|--------|------------|--------|-------------|
| ambiguous | 1.952 | 0.657 | 0.581 | 0.219 | HIGH |
| creative | 1.979 | 0.701 | 0.572 | 0.209 | HIGH |
| ethical | 1.968 | 0.696 | 0.581 | 0.228 | HIGH |
| financial | 1.890 | 0.972 | 0.603 | 0.222 | HIGH |
| interdisciplinary | 1.895 | 0.662 | 0.593 | 0.211 | HIGH |
| medical-health | 1.845 | 0.691 | 0.621 | 0.239 | HIGH |
| meta-cognitive | 2.122 | 0.814 | 0.552 | 0.234 | HIGH |
| meta-philosophical | 1.989 | 0.725 | 0.573 | 0.219 | HIGH |
| philosophical | 2.066 | 0.873 | 0.557 | 0.216 | HIGH |
| scientific | 1.945 | 3.540 | 0.610 | 0.221 | HIGH |
| songwriting | 1.932 | 0.653 | 0.584 | 0.215 | HIGH |
| technical | 1.868 | 0.687 | 0.608 | 0.225 | HIGH |

**Complexity Classification:**
- **HIGH:** High variability in both curvature and efficiency
- **MODERATE:** Moderate variability
- **LOW:** Low variability (consistent behavior)

---

## 🏆 Category Rankings

**🔹 Highest Initial Coherence:**
   1. meta-cognitive: 0.806
   2. creative: 0.792
   3. songwriting: 0.792

**📈 Strongest Stabilization:**
   1. scientific: +0.199
   2. technical: +0.184
   3. interdisciplinary: +0.178

**⚡ Most Efficient (Lowest Curvature):**
   1. medical-health: 1.845
   2. technical: 1.868
   3. financial: 1.890

---

## 🔍 Key Discoveries by Category

**ambiguous:** Significant stabilization observed (coherence improving over trajectory)

**creative:** Significant stabilization observed (coherence improving over trajectory)

**ethical:** Significant stabilization observed (coherence improving over trajectory)

**financial:** Significant stabilization observed (coherence improving over trajectory)

**interdisciplinary:** Significant stabilization observed (coherence improving over trajectory)

**medical-health:** Significant stabilization observed (coherence improving over trajectory)

**meta-cognitive:** Significant stabilization observed (coherence improving over trajectory)

**meta-philosophical:** Significant stabilization observed (coherence improving over trajectory)

**philosophical:** Significant stabilization observed (coherence improving over trajectory)

**scientific:** Significant stabilization observed (coherence improving over trajectory)

**songwriting:** Significant stabilization observed (coherence improving over trajectory)

**technical:** Significant stabilization observed (coherence improving over trajectory)

---

## 📊 Statistical Insights

**Range Analysis:**
- Curvature Range: 0.670 – 128.238 (Δ=127.567)
- Efficiency Range: 0.008 – 1.492 (Δ=1.484)

**Central Tendencies:**
- Average Curvature: 1.947
- Average Efficiency: 0.589

**Distribution:**
- Categories with Positive Coupling: 0/12 (0%)
- Total Runs Analyzed: 13112
- Total Categories: 12

